DROP TABLE IF EXISTS `content_manager_history`;
CREATE TABLE `content_manager_history` (
	`content_id` int(11) NOT NULL AUTO_INCREMENT,
	`categories_id` int(11) NOT NULL DEFAULT '0',
	`parent_id` int(11) NOT NULL DEFAULT '0',
	`group_ids` text,
	`languages_id` int(11) NOT NULL DEFAULT '0',
	`content_version` varchar(255) NOT NULL DEFAULT '',
	`content_name` text NOT NULL,
	`content_title` text NOT NULL,
	`content_heading` text NOT NULL,
	`content_text` mediumtext NOT NULL,
	`sort_order` int(4) NOT NULL DEFAULT '0',
	`file_flag` int(1) NOT NULL DEFAULT '0',
	`content_file` varchar(64) NOT NULL DEFAULT '',
	`download_file` varchar(64) NOT NULL DEFAULT '',
	`content_status` int(1) NOT NULL DEFAULT '0',
	`content_group` int(11) NOT NULL DEFAULT '0',
	`content_delete` int(1) NOT NULL DEFAULT '1',
	`gm_link` text NOT NULL,
	`gm_link_target` varchar(10) NOT NULL DEFAULT '',
	`gm_priority` varchar(3) NOT NULL DEFAULT '0.5',
	`gm_changefreq` varchar(255) NOT NULL DEFAULT 'weekly',
	`gm_last_modified` timestamp NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	`gm_sitemap_entry` int(1) NOT NULL DEFAULT '1',
	`gm_robots_entry` int(1) NOT NULL DEFAULT '0',
	`gm_url_keywords` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL DEFAULT '',
	`contents_meta_title` text NOT NULL,
	`contents_meta_description` text NOT NULL,
	`contents_meta_keywords` text NOT NULL,
	`opengraph_image` VARCHAR(255) NULL DEFAULT NULL,
	`content_position` varchar(64) NOT NULL,
	`content_type` varchar(64) NOT NULL,
	`protected` varchar(64) NOT NULL DEFAULT '',
	PRIMARY KEY (`content_id`),
	UNIQUE KEY `content_group` (`content_group`,`languages_id`, `content_version`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
